/* Copyright (C) 1999 Lucent Technologies */
/* Kod z książki The Practice of Programming */
/* Briana W. Kernighana i Roba Pike'a */

import java.io.*;
import java.util.*;

class Chain {
	static final int NPREF = 2;	// Rozmiar przedrostka
	static final String NONWORD = "\n";
					// „Słowo”, które nie może pojawić się w danych wejściowych
	Hashtable statetab = new Hashtable(); 
					// klucz = przedrostek, wartość = wektor przyrostków
	Prefix prefix = new Prefix(NPREF, NONWORD);
					// Przedrostek początkowy
	Random rand = new Random();

// Metoda build z klasy Chain: tworzy tablicę stanów z danych pobieranych na wejściu
void build(InputStream in) throws IOException
{
	StreamTokenizer st = new StreamTokenizer(in);
		
	st.resetSyntax();                     // Usuwa domyślne reguły
	st.wordChars(0, Character.MAX_VALUE); // Włącza wszystkie znaki
	st.whitespaceChars(0, ' ');           // oprócz spacji
	while (st.nextToken() != st.TT_EOF)
		add(st.sval);
	add(NONWORD);
}

// Metoda add z klasy Chain: dodaje słowo do listy przyrostków i aktualizuje przedrostek
void add(String word)
{
	Vector suf = (Vector) statetab.get(prefix);
	if (suf == null) {
		suf = new Vector();
		statetab.put(new Prefix(prefix), suf);
	}
	suf.addElement(word);
	prefix.pref.removeElementAt(0);
	prefix.pref.addElement(word);
}

// Metoda generate z klasy Chain: generuje tekst wyjściowy
void generate(int nwords)
{
	prefix = new Prefix(NPREF, NONWORD);
	for (int i = 0; i < nwords; i++) {
		Vector s = (Vector) statetab.get(prefix);
		if (s == null) {
			System.err.println("Markov: błąd wewnętrzny: brak stanu");
			System.exit(1);
		}
		int r = Math.abs(rand.nextInt()) % s.size();
		String suf = (String) s.elementAt(r);
		if (suf.equals(NONWORD))
			break;
		System.out.println(suf);
		prefix.pref.removeElementAt(0);
		prefix.pref.addElement(suf);
	}
}
}

class Prefix {
	public Vector pref;	// NPREF kolejnych słów ze strumienia wejściowego
static final int MULTIPLIER = 31;	// dla funkcji hashCode()

// Konstruktor klasy Prefix: kopiuje istniejący przedrostek 
Prefix(Prefix p)
{
	pref = (Vector) p.pref.clone();
}

// Konstruktor klasy Prefix: tworzy n kopii łańcucha str
Prefix(int n, String str)
{
	pref = new Vector();
	for (int i = 0; i < n; i++)
		pref.addElement(str);
}

// Metoda hashCode z klasy Prefix: generuje wartość mieszania z wszystkich słów tworzących przedrostek
public int hashCode()
{
	int h = 0;

	for (int i = 0; i < pref.size(); i++)
		h = MULTIPLIER * h + pref.elementAt(i).hashCode();
	return h;
}

// Metoda equals z klasy Prefix: sprawdza czy w porównywanych prefiksach znajdują się takie same słowa
public boolean equals(Object o)
{
	Prefix p = (Prefix) o;

	for (int i = 0; i < pref.size(); i++)
		if (!pref.elementAt(i).equals(p.pref.elementAt(i)))
			return false;
	return true;
}

}

class Markov {
	static final int MAXGEN = 10000; // Limit liczby wygenerowanych słów
	public static void main(String[] args) throws IOException
	{
		Chain chain = new Chain();
		int nwords = MAXGEN;

		chain.build(System.in);
		chain.generate(nwords);
	}
}
